<?php
class Quotation extends Eloquent {
  protected $fillable = ['product_id', 'customer_quot_id', 'amount', 'user_id'];

  /**
   * Get a Quotation
   * @param  int $id 
   * @return object     
   */
  public static function getQuotation($id)
  {
  	$quotation = Quotation::leftJoin('customers', 'customers.id', '=', 'quotations.customer_id')
												->select(
														'quotations.id',
														'quotations.customer_id', 
														'customers.first_name', 
														'customers.last_name',
														'quotations.status',
														'quotations.created_at'
													)
												->where('quotations.id', $id)
												->whereIn('status', ['closed', 'approved', 'cancel'])
												->where('quotations.id', $id)
												->first();
		return $quotation;
  }
  /**
   * Get Product in PreOrder for a quotation
   * @param  int $id
   * @return array
   */
  public static function getPreOrders($id)
  {
  	$preOrders = DB::table('products as p')
									 ->join('pre_orders as o', 'o.product_id', '=', 'p.id')
									 ->select('o.*', 'p.name', 'p.sku')
									 ->where('quotation_id', $id)->get();
		return $preOrders;
  }

}
