<?php 
class PreOrder extends Eloquent {
	protected $fillable = [ 'quotation_id', 'product_id', 
												 'amount', 'user_id', 
												 'is_order', 'price' ];

	public static function getOrders($id)
	{
		$preOrders = DB::table('quotations as q')
									 	->join('pre_orders as o', 'q.id', '=', 'o.quotation_id')
										->join('products as p', 'p.id', '=', 'o.product_id')
										->select('o.*', 'p.sku')
										->where("o.quotation_id", $id)
										->where('o.is_order', 0)
										->where('q.status', 'closed')->get();
		return $preOrders;
	}
}