<?php

class Order extends \Eloquent {
	protected $fillable = ["invoice_id","product_id","amount","stock_id","price","discount","note","sold", 'sku'];
		public static function itemExisting($invoiceId, $productId)
	{
	  return self::where('invoice_id', $invoiceId)
	  					 ->where('product_id', $productId)
	  					 ->first();
	}

	public static function orderedProduct($id)
	{
		return self::join('Products','Products.id','=','Orders.product_id')
					->where('Orders.id',$id)
					->select([
						'Orders.*',
						'Products.name',
						'Products.name_kh',
						'Products.sku',
						'Products.thumbnail'
						])->first();
	}
}