<?php

class Mortgage extends \Eloquent {
	protected $fillable = [
	    'fullname',
        'tel',
        'id_card',
        'address',
        'product_name',
        'product_id',
        'photo',
        'start_date',
        'end_date',
        'price',
        'price_out',
        'rate',
        'note',
        'user_id'
    ];

	public static $rules = [
        'fullname'  => 'required',
        'tel'       => 'required',
        'id_card'   => 'required',
        'product_name' => 'required',
        'product_id' =>  "required",
        'price'     =>  "required",
        'price_out' => 'required',
        'rate'      =>  "required",
        'start_date' =>  "required|regex:/^[0-9]{1,2}\/[0-9]{1,2}\/[0-9]{4}$/",
        'end_date'  => 'required|regex:/^[0-9]{1,2}\/[0-9]{1,2}\/[0-9]{4}$/'
    ];
    /**
     * Get Mortgage Price
     * @return mixed
     */
	public function getPrice()
    {
        return $this->price_out;
    }

    /**
     * Get Mortgage Rate
     * @return float|int
     */
    public function getRate()
    {
        return $this->rate / 100;
    }

    public function getTotalInterest()
    {
        return round($this->getPrice() * $this->getRate(), 2);
    }

    public function getTotalPayment()
    {
        return $this->getPrice() + $this->getTotalInterest();
    }

    public function divideByTwo()
    {
        return $this->getTotalInterest() / 2;
    }

    public function scopeFilterCustomer($query, $pattern)
    {
        return $query->where(function ($q) use ($pattern) {
            $q->where('fullname', 'LIKE', $pattern)
                ->orWhere('tel', 'LIKE', $pattern);
        });
    }

    public function totalL15Payment()
    {
        return $this->getPrice() + $this->divideByTwo();
    }
}