<?php
class LoanCustomer extends \Eloquent {

   /**
    * fillable field in table of database
    * @return array
    */
   protected $fillable = [
       'full_name_kh', 'full_name_en', 'gender',
       'marital_status', 'nationality', 'dob', 'id_card_no',
       'tel', 'education', 'house_number', 'road_number',
       'group_number', 'village', 'commune',
       'district', 'province', 'property',
       'date_of_stay', 'live_with', 'photo', 'other_education'
   ];
   public static $rules = [
       'full_name_kh' => 'required',
       'full_name_en' => 'required',
       'tel' => 'required|unique:loan_customers',
       'id_card_no' => 'required|unique:loan_customers',
   ];

   public function company()
   {
       return $this->hasOne('Company', 'id');
   }

   public function garantor()
   {
      return $this->hasOne('Garantor', 'id');
   }
}
