<?php

class Invoice extends \Eloquent {
	protected $fillable = ["status","total","recieved_dollar",
												"recieved_riel","recieved","changed",
												"deposit","stock_id","user_id",
												"customer_id","referral_id","rate","comment"];

	/**
	 * Start Today
	 * @return mix
	 */
	public static function getToday()
	{
		return Carbon\Carbon::today();
	}
	/**
	 * End Today
	 * @return mix
	 */
	public static function getEndToday()
	{
		$endToday = Carbon\Carbon::today();
	  $endToday->addHours(23)
						 ->addMinutes(59)
						 ->addSeconds(59);
		return $endToday;
	}
	/**
	 * Get Invoices Today
	 * @return array object of invoices today
	 */
	public static function getInvoicesToday()
	{
	  $invoiceToday = DB::table('invoices')
										->whereBetween('created_at', [static::getToday(), static::getEndToday()])
										->get();
		return $invoiceToday;
	}
	/**
	 * Get Sale Today
	 * @return double total
	 */
	// public static function getSaleToday()
	// {
	// 	$total = DB::table('invoices')
	// 							->whereBetween('created_at', [static::getToday(), static::getEndToday()])->sum('recieved');
	// 	return number_format($total, 2, '.', ',');
	// }
	public static function getInvoicesDeposit()
	{
		$invoices = DB::table('customers as c')
                  ->join('invoices as i', 'i.customer_id','=', 'c.id')
									->where('i.deposit', '>', 0)
									->where('status', 'closed')
                  ->select(
													'c.first_name',
													'c.last_name',
													'i.id',
													'i.total',
													'i.recieved',
													'i.deposit',
													'i.created_at'
													)->get();
    return $invoices;
	}
	public static function getInvoiceById($id)
	{
		$invoice = DB::table('customers as c')
                  ->join('invoices as i', 'i.customer_id','=', 'c.id')
									->where('i.id', '=', $id)
                  ->select(
													'c.first_name',
													'c.last_name',
													'i.id',
													'i.total',
													'i.recieved',
													'i.deposit',
													'i.created_at'
													)->first();
		return $invoice;
	}
	/**
	 * Search Invoice With datetimes picker
	 * @param  [type] $startDate [description]
	 * @param  [type] $endDate   [description]
	 * @param  [type] $deposit   [description]
	 * @return array objects
	 */
	public static function searchInvoice($startDate = null, $endDate = null, $deposit = false)
	{
		$startDate ? $startDate : $startDate = static::getToday();
		$endDate ? $endDate : $endDate = static::getEndToday();
		$invoices = DB::table('invoices')
									->where('status', 'closed')
									->whereNull('referral_id')
									->whereBetween('created_at', [$startDate, $endDate]);

		if ($deposit) {
			$invoices->where('deposit', '>', 0);
		}
		return $invoices->paginate(10);
	}
	/**
	 * Get Sale Today
	 * @return double total
	 */
	public static function getSaleToday(){
		$total = Invoice::closed()->whereBetween('created_at', [static::getToday(), static::getEndToday()])->sum('total');
		return number_format($total, 2, '.', ',');
	}
	/**
	 * Get Sale So Far
	 * @return double total
	 */
	public static function getSaleSoFar()
	{
		$total = Invoice::closed()->sum('total');
		return number_format($total, 2, '.', ',');
	}
	public static function scopeDraft($query)
	{
		return $query->whereStatus('draft');
	}
	public static function scopeClosed($query)
	{
		return $query->whereStatus('closed');
	}
	public static function scopeFromStock($query)
	{
		return $query->whereStockId(Auth::user()->stock_id);
	}
	public static function getProductsWithInvoiceId($id)
	{
		$products = DB::table('orders as o')
										->join('products as p', 'o.product_id', '=', 'p.id')
										->join('invoices as i', 'o.invoice_id', '=', 'i.id')
										->where('i.id','=', $id)
										->select('p.name', 'o.price', 'o.amount')
										->get();
		return $products;

	}
	/**
	 * Get Invoice Deposit ID
	 * @return array id of invoices deposit
	 */
	public static function getInvoicesDepositID()
	{
		$invoices = DB::table('customers as c')
                  ->join('invoices as i', 'i.customer_id','=', 'c.id')
									->where('i.deposit', '>', 0)
									->where('i.status', 'closed')
                  ->select('i.id')->lists('i.id');
		return $invoices;
	}
	/**
	 * Get Expired Invoices
	 * @return array object
	 */
	public static function getExpiredInvoices()
	{
		$invoiceID = self::getInvoicesDepositID();
		if(empty($invoiceID)) return [];
		$now = \Carbon\Carbon::now();
		$invoices = [];
		foreach ($invoiceID as $id) {
			$invoice = Invoice::find($id);
			if($now >= self::getUpdated($invoice->updated_at)) {
				$invoices[] = $invoice;
			}
		}
		return $invoices;
	}
	/**
	 * Get Updated Date and add days in config
	 * @param  datetime
	 * @return datetime
	 */
	private static function getUpdated($day)
	{
		$update = new \Carbon\Carbon($day);
		$update->addDays(\Helper::getConfig('invoice_alert_day'));
		return $update;
	}
}
