<?php 
/**
 * Class EmiInstallment
 * @author Sok Kimsoeurn <sokkimsoeurn@gmail.com>
 */

class EmiInstallment extends Installment 
{
    /**
     * Table Name
     *
     * @var string
     */
    protected $table = "installments";

    /**
     * Get EMI
     * @return float 
     */
    public function getEMIRate()
    {
        return $this->rate / 100;
    }

    /**
     * Get Total Rate
     * @return [type] [description]
     */
    public function getTotalRate()
    {
        return ($this->rate / 100) * $this->getTotalPrice();
    }

    /**
     * Get total EMI Payment
     * @return [type] [description]
     */
    public function getTotalEMIPayment()
    {
        return $this->getEMImonthlyPayment() * $this->duration;
    }

    /**
     * [getEMITotalRate description]
     * @return [type] [description]
     */
    public function getEMITotalRate()
    {
        return $this->getTotalPayment() - $this->getPriciple();
    }

    /**
     * Get EMI Monthly payment
     * @return int 
     */
    public function getEMIAmount()
    {
        $rate = $this->getEMIRate();
        $expon =  pow((1 + $rate), $this->getDuration());
        $monthly = ($this->getPriciple() * $expon * $rate) / ($expon-1);
        return round($monthly, 2);
    }       

    /**
     * Get Total EMI Payment
     * @return float
     */
    public function getTotalPayment()
    {
        return $this->getEMIAmount() * $this->getDuration();
    }

    /**
     * Get Monthly payment 
     * @return integer
     */
    public function emiPayment()
    {
        return floor($this->getEMIAmount());
    }

    /**
     * Get two decimal after getEMIAmount
     * @return float
     */
    public function extraFirstMonth()
    {
        $result = $this->getTotalPayment() - ($this->emiPayment() * $this->getDuration());
        return $result > 0 ? $result : 0;
    }

    /**
     * All decimal price store in first month
     * @return float
     */
    public function firstMonth()
    {
        return $this->emiPayment() + $this->extraFirstMonth();
    }

    /**
     * GET Flat Rate
     * @return float
     */
    public function flatRate()
    {
        $monthlyInterest = $this->getEMITotalRate() / $this->getDuration();
        $rate  = $monthlyInterest / $this->getPriciple();
        return round($rate * 100, 2);
    }

    public function flatRateAmount()
    {
        $flat = $this->flatRate() / 100;
        $rateWithFlate = $flat * $this->getPriciple();
        $totalFlat = $rateWithFlate * $this->getDuration();
        return $totalFlat;
    }

    public function addInterest()
    {
        $totalFlat = $this->flatRateAmount();
        $addRate = 0;
        if ($totalFlat > $this->getEMITotalRate()) {
            $addRate = $totalFlat - $this->getEMITotalRate();
        } else {
            $addRate = $totalFlat - $this->getEMITotalRate();
        }
        return $addRate;
    }

    public function futureValue()
    {
        return $this->getTotalPayment() + $this->addInterest();
    }

    public function displayFirstMonth()
    {
        return $this->firstMonth() + $this->addInterest();
    }
}