<?php 
class EMILoan {
    private    $amount;      //amount of the loan
    private    $rate;        //percentage rate of the loan
    private    $years;        //number of years of the loan
    private    $npmts;        //number of payments of the loan
    private    $mrate;        //monthly interest rate
    private    $tpmnt;        //total amount paid on the loan
    private    $tint;         //total interest paid on the loan
    private    $pmnt;         //monthly payment of the loan


    public function __construct($amount=0,$rate=0,$years=0)
    {
        $this->amount=$amount;   //amount of the loan
        $this->rate=$rate;       //yearly interest rate in percent
        $this->years=$years;     //length of loan in years
        if($amount*$rate*$years > 0){
            $this->npmts=$years*12;  //number of payments (12 per year)
            $this->mrate=$rate/1200; //monthly interest rate
            $this->pmnt=$amount*($this->mrate/(1-pow(1+$this->mrate,-$this->npmts))); //monthly payment
            $this->tpmnt=$this->pmnt * $this->npmts;  //total amount paid at end of loan
            $this->tint=$this->tpmnt-$amount;         //total amount of interest paid at end of loan
        } else {
            $this->pmnt=0;
            $this->npmts=0;
            $this->mrate=0;
            $this->tpmnt=0;
            $this->tint=0;
        }
    }
    public function payment()
    {
        return sprintf("%01.2f",$this->pmnt);
    }

    public function totpayment()
    {
        return sprintf("%01.2f",$this->tpmnt);
    }
    public function addFirstMonth($i)
    {
        $monthlyPayment = floor($this->pmnt);
        $sumTotal = $monthlyPayment * $this->npmts;
        $extraFirstMonth = round(($this->pmnt *  $this->npmts) - $sumTotal, 2);
        $firstMonth = $monthlyPayment + $extraFirstMonth;
        $mPayment = $i == 1 ? $firstMonth  : $monthlyPayment;
        return round($mPayment);
    }
    public function pMomthly()
    {
        return round($this->pmnt, 0);
    }
    public function extraMonth()
    {
        return $this->tpmnt - ($this->pMomthly() * $this->npmts);
    }

    public function payM($i) {
        return $i== 1 ? $this->pMomthly() + $this->extraMonth() : $this->pMomthly();
    }
    public function totinterest()
    {
        return sprintf("%01.2f",$this->tint);
    }



    //if $show is false:
    //     displays:
    //               monthly payment
    //               number of payments in the loan
    //               total paid at end of loan
    //               total interest paid at end of loan
    //if $show is true:
    //    displays: everything for false case plus the amortization table

    function showTable($show){
        print "<table border='1' width='100%'>";
        print "<td width='25%' align='center'><dt>Total Payments</dt>";
        print "<dt>";
        print sprintf("$%01.2f",$this->tpmnt);
        print "</dt></td>";
        print "<td width='25%' align='center'><dt>Total Interest</dt>";
        print "<dt>";
        print sprintf("$%01.2f",$this->tint);
        print "</dt></td>";
        print "<td width='25%' align='center'><dt>Number of Monthly Payments</dt>";
        print "<dt>";
        print $this->npmts;
        print "</dt></td>";
        print "<td width='25%' align='center'><dt>Monthly Payment</dt>";
        print "<dt>";
        print sprintf("$%01.2f",$this->pmnt);
        print " ". $this->pMomthly();
        print " " . $this->extraMonth();
        print "</dt>";
        print "</td></tr>";
        if($show){
            print "</table>";
            print "<table class='table table-striped table-bordered'>`<tr>";
            print "<td width='14%' align='center'>Payment Number</td>";
            print "<td width='14%' align='center'>Beginning Balance</td>";
            print "<td width='14%' align='center'>Interest Payment</td>";
            print "<td width='14%' align='center'>Principal Payment</td>";
            print "<td width='14%' align='center'>Ending Balance</td>";
            print "<td width='14%' align='center'>Cumulative Interest</td>";
            print "<td width='14%' align='center'>Cumulative Payments</td>";
            print "</tr>";
                $ebal = $this->amount;
                $ccint =0.0;
                $cpmnt = 0.0;
                $tp = 0.0;
                $tr = 0.0;
                for ($pnum = 1; $pnum <= $this->npmts; $pnum++){
                    print "<tr>";
                    print "<td width='14%' align='center'>". $pnum. "</td>";
                    $bbal = $ebal;
                    print "<td width='14%' align='right'>$". sprintf("%01.2f",$bbal) . "</td>";
                    $ipmnt = $bbal * $this->mrate;
                    $tr += $ipmnt;
                    print "<td width='14%' align='right'>$" . sprintf("%01.2f",$ipmnt) . "</td>";
                    $ppmnt = $this->pmnt - $ipmnt;
                    $tp += $ppmnt;
                    print "<td width='14%' align='right'>$" . sprintf("%01.2f",$ppmnt) .  " " .$this->pmnt. "</td>";
                    $ebal = $bbal - $ppmnt;
                    print "<td width='14%' align='right'>$" . sprintf("%01.2f",$ebal) . "</td>";
                    $ccint = $ccint + $ipmnt;
                    print "<td width='14%' align='right'>$" . sprintf("%01.2f",$ccint) . "</td>";
                    $cpmnt = $cpmnt + $this->pmnt;
                    print "<td width='14%' align='right'>$" . sprintf("%01.2f",$cpmnt) . "</td>";
                    print "</tr>";
                }
                print "</table>";
                print $tp;
                print "<br>";
                print $tr;
            }       
        }
    }