<?php
class CustomerQuotation extends Eloquent {
  protected $table = "customer_quotations";
  protected $fillable = ['status', 'customer_id', 'user_id'];
  /**
   * Get total price of quotation
   * @param  int $id  customerID
   * @param  int $qid CustomerQuotation
   * @return float      total price
   */
  public static function getTotal($id, $qid)
  {
    $products = DB::table('products as p')
                  ->join('quotations as q', 'q.product_id', '=', 'p.id')
                  ->join('customer_quotations as cq', 'cq.id', '=', 'q.customer_quot_id')
                  ->select(
                  'p.price',
                  'q.amount')
                  ->where('cq.id', $qid)
                  ->where('cq.status', 'closed')
                  ->where('cq.customer_id', $id)
                  ->get();
    if(empty($products)) return null;
    $total = 0;
    foreach ($products as $product) {
      $total += (float) $product->price * $product->amount;
    }
    return $total += $total * (\Helper::getConfig('invoice_tax')/100);
  }
}
