<?php

class Customer extends Eloquent {
	protected $fillable = [
		'first_name', 'last_name', 'sex', 'branch_id',
		'email', 'tel', 'age', 'photo', 'id_card', 'dob',
		'note', 'address', 'user_id'];
  protected $table = "Customers";
	public static $rules = [
		'tel' => 'unique:customers'
	];

  public function branch() {
    return $this->belongsTo('Branch');
  }

	public function fullName()
	{
		if (isset($this->first_name) && isset($this->last_name)) {
			return $this->first_name . " " . $this->last_name;
		}
	}
	public static function members()
	{
		$members = static::all();
		return count($members);
	}
	/**
	 * get first name and last name
	 */
	public static function getFullName()
	{
	    return self::leftJoin('installments', 'installments.customer_id', '=', 'customers.id')
                    ->select(DB::raw("CONCAT(customers.first_name, ' ', customers.last_name) AS full_name, customers.id"))
                    ->whereNull('installments.customer_id')
                    ->orWhere('installments.status', 'completed');
	}

    public function displayDob()
    {
        $d = new \Carbon\Carbon($this->dob);
		return $d->format('d/m/Y');
    }
}
