<?php
namespace app\helper;
class UserRole {

	/**
	 * Get List of Permission by Role ID
	 *
	 * @var integer Role ID
	 * @return  array Permission ID List with array format
	 **/

	public static function getPermissionByRole($role_id)
	{
		$permissions = \PermissionRole::where('role_id','=',$role_id)->get()->toArray();
		return array_pluck($permissions,'permission_id');
	}

	/**
	 * Get List of Permission Name by Role ID
	 *
	 * @var integer Role ID
	 * @return array  Permission Name List with array format
	 **/
	

	public static function getPermissionNameByRoleId($role_id)
	{
		$permissions = \Permission::whereIn('id',UserRole::getPermissionByRole($role_id))->get()->toArray();
		return array_pluck($permissions,'permission_name');
	}

	/**
	 * Get List of Permission Name by Role ID
	 *
	 * @var integer Role ID
	 * @return array  Permission Name List with array format
	 **/
	

	public static function removePermissionByRoleId($role_id)
	{
		$removePermissionByRole = \PermissionRole::where('role_id', '=', $role_id)->delete();
		return true;
	}

	/**
	 * Check if This Role has permission
	 *
	 * @var integer Role ID
	 * @var string [permission]
	 * @return boolean
	 **/
	
	public static function has($can)
	{
		if(getField('Role','id',\Auth::user()->role_id,"role_name") == "Master") return 1;
		$role_id = \Auth::user()->role_id;
		$permissions = self::getPermissionNameByRoleId($role_id);
		return in_array($can,$permissions);
	}
}