<?php
namespace app\helper;
/**
*
*/
class InvoiceHelper
{
	/*
	 * Invoice Helper Class
	 */

	/*
	 * Description Get invoice Number, if invoice is not created, generate one
	 * @param stockID id of current branch
	 * @return Invoice ID
	 */
	public static function getInvoiceID() {
		$id = \Auth::user()->stock_id;
		$userId = \Auth::user()->id;
		$invoiceID = \DB::table('Invoices')->where(function($query) use ($id,$userId) {
			$query->where('status','open')
			    ->where('user_id', '=',$userId)
					->where('stock_id', '=',$id);
		})->first();
		if(!empty($invoiceID->id)){
			return $invoiceID->id;
		}
		else {
			$invoice = new \Invoice;
			$invoice->status = 'open';
			$invoice->stock_id = $id;
			$invoice->total = 0;
			$invoice->recieved = 0;
			$invoice->changed = 0;
			$invoice->deposit = 0;
			$invoice->rate = \Helper::getConfig('invoice_rate');
			$invoice->tax = \Helper::getConfig('invoice_tax');
			$invoice->user_id = \Auth::user()->id;
			$invoice->save();
			return $invoice->id;
		}
	}
	public static function getTotal($invoiceId = "") {
		if($invoiceId == "")
			$invoiceID = self::getInvoiceID();
		else
			$invoiceID = $invoiceId;
		$items_incart = \DB::table('Orders')->where('invoice_id',$invoiceID)->get();
		$total_price= 0;
		$total_amount = 0;
		foreach($items_incart as $item) :
			$total_amount += $item->amount;
			$total_price  += $item->price*$item->amount;
		endforeach;
		return $total_price;
	}
	public static function updateTotal() {
		$invoiceID = self::getInvoiceID();
		$total = self::getTotal();
		$invoice = \Invoice::find($invoiceID);
		$invoice->total = self::calculateTax();
		$invoice->created_at = \Carbon\Carbon::now();
		$invoice->rate = \Helper::getConfig('invoice_rate');
		$invoice->tax = \Helper::getConfig('invoice_tax');
		$invoice->save();
		return $total;
	}
	public static function calculateTax() {
		$grandTotal = ((self::getTotal()*\Helper::getConfig('invoice_tax'))/100)+self::getTotal();
		return $grandTotal;
	}
	public static function getSuspenedInvoice()
	{
		$userId = \Auth::user()->id;
		$stockId = \Auth::user()->stock_id;
		$invoiceID = \DB::table('Invoices')->where(function($query) use ($stockId,$user) {
		$query->where('status','draft')
		      ->where('user_id', '=',$userId)
					->where('stock_id', '=',$stockId);
		})->orderBY('id','DESC')->get();
		return $invoiceID;
	}
	public static function suspendInvoice($customer=null) {

		$invoiceID = self::getInvoiceID();
		$invoice = \Invoice::find($invoiceID);
		if ($invoice->total > 0) {
			$invoice->status = 'draft';
		}
		$invoice->customer_id = $customer;
		$invoice->save();
		return true;
	}
	public static function switchInvoice($switchToInvoice) {
		$invoiceID = $switchToInvoice;
		self::suspendInvoice();
		$invoiceID = \Invoice::find($switchToInvoice);
		$invoiceID->status = 'open';
		$invoiceID->save();

		return true;
	}
	public static function convertInvoiceNumber($invoicenumber) {
		if($invoicenumber == "") return;
		switch(strlen($invoicenumber)) {
			case 1: $invoicenumber="00000".$invoicenumber;
				break;
			case 2: $invoicenumber="0000".$invoicenumber;
				break;
			case 3: $invoicenumber="000".$invoicenumber;
				break;
			case 4: $invoicenumber="00".$invoicenumber;
				break;
		}
		return $invoicenumber;
	}
	/**
	 * Get Supplier Invoice ID
	 * @return int
	 */
	public static function getSupInvoiceID($supplier_id)
	{
		$user_id = \Auth::user()->id;
		$invoice = \DB::table('supplier_invoices')
											->where('status', "draft")
											->where('user_id', $user_id)
											->where('supplier_id', $supplier_id)
											->first();
		if (!empty($invoice->id)) return $invoice->id;
		$invoice = new \SupplierInvoice;
		$invoice->status = 'draft';
		$invoice->supplier_id = $supplier_id;
		$invoice->total = 0;
		$invoice->pay = 0;
		$invoice->changed = 0;
		$invoice->payable = 0;
		$invoice->rate = \Helper::getConfig('invoice_rate');
		$invoice->tax = \Helper::getConfig('invoice_tax');
		$invoice->user_id = \Auth::user()->id;
		if ($invoice->save()) return $invoice->id;
		return null;
	}
}
