<?php

namespace app\helper;

class Helper
{
    /**
     * Upload Files
     *
     * @var File : File that want to update
     * @return  array Permission ID List with array format
     **/
    public static function uploadFile($input, $destinationPath)
    {
        $file = $input;
        $fileFolder = $destinationPath;
        $destinationPath = public_path() . DIRECTORY_SEPARATOR . $destinationPath;
        $filename = $file->getClientOriginalName();
        $extension = $file->getClientOriginalExtension();
        $filename = uniqid() . '_' . strtolower(str_replace(' ', '_', $filename));
        $file->move($destinationPath, $filename);
        return $fileFolder . $filename;
    }

    public static function getConfig($key = '')
    {
        if ($key == '') {
            return;
        }
        $setting = \Setting::whereMeta_key($key)->first();
        if (empty($setting->meta_value)) {
            return false;
        }
        return $setting->meta_value;
    }

    public static function countItems($model, $id, $compare_field = 'id')
    {
        $items = \DB::table($model)->where($compare_field, '=', $id)->count();
        return $items;
    }

    public static function dateFormat($date)
    {
        $date = new \Carbon\Carbon($date);
        return $date->format('D-d-M-Y');
    }

    public static function getProfitByMonth($month = null, $type = null)
    {
        $month = $month . '-01';
        $start = new \Carbon\Carbon($month);
        $start->startOfMonth();
        $end = new \Carbon\Carbon($month);
        $end->endOfMonth();
        $totalProfit = \Profit::where(function ($query) use ($start,$end,$type) {
            $query->where('type', $type)
        ->whereBetween('updated_at', [$start, $end]);
        })->sum('amount');
        return $totalProfit;
    }

    public static function checkApp()
    {
        exec('getmac', $result);
        $address = substr($result[3], '0', '18');
        return $address;
    }

    public static function createMaster($username, $password, $role)
    {
        $user = new \User;
        $user->first_name = 'Master';
        $user->last_name = 'Pos';
        $user->sex = 'Male';
        $user->username = $username;
        $user->password = \Hash::make($password);
        $user->status = 1;
        $user->role_id = $role;
        if ($user->save()) {
            return true;
        }
        return false;
    }

    public static function getCustomerQuotID($customer_id)
    {
        $user_id = \Auth::user()->id;
        $quotationID = \CustomerQuotation::where('status', 'open')
                                                 ->where('user_id', $user_id)
                                                 ->where('customer_id', $customer_id)
                                                 ->first();
        if (!empty($quotationID->id)) {
            return $quotationID->id;
        } else {
            $quotation = new \CustomerQuotation;
            $quotation->status = 'open';
            $quotation->customer_id = $customer_id;
            $quotation->user_id = \Auth::user()->id;
            $quotation->save();
            return $quotation->id;
        }
    }
}
