<?php

// Composer: "fzaninotto/faker": "v1.3.0"
use Faker\Factory as Faker;

class SettingsTableSeeder extends Seeder {

	public function run()
	{
		DB::table('Settings')->delete();
		$configs = [
			"company_name" => 
				[
					'meta_key'=>'company_name',
					'meta_value'	=>	'Lifestyle Technologies',
					'group'=>'company_info',
					'input_type'	=>'text'
				],
			"company_tel" => 
				[
					'meta_key'=>'company_tel',
					'meta_value'	=>	'016 96 88 29',
					'group'=>'company_info',
					'input_type'	=>'number'
				],
				"company_email" => 
				[
					'meta_key'=>'company_email',
					'meta_value'	=>	'lifestyle.tech.cambodia@gmail.com',
					'group'=>'company_info',
					'input_type'	=>'email'
				],
				"company_website" => 
				[
					'meta_key'=>'company_website',
					'meta_value'	=>	'lifestyle-cambodia.com',
					'group'=>'company_info',
					'input_type'	=>'text'
				],
				"company_facebook" => 
				[
					'meta_key'=>'company_facebook',
					'meta_value'	=>	'www.facebook.com/lifestylecambodia',
					'group'=>'company_info',
					'input_type'	=>'text'
				],
				"company_twitter" => 
				[
					'meta_key'=>'company_twitter',
					'meta_value'	=>	'',
					'group'=>'company_info',
					'input_type'	=>'text'
				],
				"company_line" => 
				[
					'meta_key'=>'company_line',
					'meta_value'	=>	'',
					'group'=>'company_info',
					'input_type'	=>'text'
				],
				"company_logo" => 
				[
					'meta_key'=>'company_logo',
					'meta_value'	=>	'',
					'group'=>'company_info',
					'input_type'	=>'file'
				],
				"company_sale_interface" => 
				[
					'meta_key'=>'company_sale_interface',
					'meta_value'	=>	'',
					'group'=>'company_info',
					'input_type'	=>'select'
				],
				"company_address" => 
				[
					'meta_key'=>'company_address',
					'meta_value'	=>	'',
					'group'=>'company_info',
					'input_type'	=>'textarea'
				],
				

				"invoice_type" => 
				[
					'meta_key'=>'invoice_type',
					'meta_value'	=>	'',
					'group'=>'invoice',
					'input_type'	=>'select'
				],
				"invoice_rate" => 
				[
					'meta_key'=>'invoice_rate',
					'meta_value'	=>	'4100',
					'group'=>'invoice',
					'input_type'	=>'number'
				],
				"invoice_client_note" => 
				[
					'meta_key'=>'invoice_client_note',
					'meta_value'	=>	'',
					'group'=>'invoice',
					'input_type'	=>'textarea'
				],
				"invoice_payment_term" => 
				[
					'meta_key'=>'invoice_payment_term',
					'meta_value'	=>	'',
					'group'=>'invoice',
					'input_type'	=>'textarea'
				],
				"invoice_footer" => 
				[
					'meta_key'=>'invoice_footer',
					'meta_value'	=>	'',
					'group'=>'invoice',
					'input_type'	=>'textarea'
				],
			];
		foreach($configs as $config => $value)
		{
			Setting::create([
				'meta_key'		=> $value['meta_key'],
				'meta_value'	=> $value['meta_value'],
				'group'				=> $value['group'],
				'input_type'	=> $value['input_type']
			]);
		}
	}

}