<?php

// Composer: "fzaninotto/faker": "v1.3.0"
use Faker\Factory as Faker;

class ProductTableSeeder extends Seeder {

	public function run()
	{
		$faker = Faker::create();
    DB::table('Products')->delete();
		foreach(range(1, 10) as $index)
		{
      $supplier = Supplier::orderBy(DB::raw('RAND()'))->first();
      $category = ProductCategory::orderBy(DB::raw('RAND()'))->first();
      $user = User::first();
      $location = itemLocation::orderBy(DB::raw('RAND()'))->first();
      $unit = Unit::orderBy(DB::raw('RAND()'))->first();
			Product::create(array(
        'sku' => $faker->ean8,
        'name' => $faker->name,
        'name_kh' => $faker->name,
        'price_in' => $faker->numberBetween(2,3),
        'price' => $faker->numberBetween(2,3),
        'price_wholesale' => $faker->numberBetween(2,3),
        'thumbnail' => $faker->imageUrl,
        'discount' => 0,
        'amount' => $faker->numberBetween(10,30),
        'min_amount' => 5,
        'user_id' => $user->id,
        'is_service'  => $faker->boolean(10),
        'supplier_id' => $supplier->id,
        'item_location_id' => $location->id,
        'product_category_id' => $category->id,
        'unit_id' => $unit->id,
        'expired_date' => $faker->dateTimeThisYear
      ));
		}
	}
}