<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CrateMortgagePaymentsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('mortgage_payments', function(Blueprint $table)
		{
			$table->increments('id');
			$table->integer('mortgage_id');
			$table->date('payment_date');
			$table->timestamp('fee_date');
			$table->float('amount');
			$table->float('principal');
			$table->float('interest');
			$table->boolean('is_paid_interest')->default(0);
			$table->boolean('is_paid')->default(0);
			$table->text("note")->nullable();
			$table->integer('receipt_id')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('mortgage_payments');
	}

}
