<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMortgagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mortgages', function(Blueprint $table) {
            $table->increments('id');
            $table->string('fullname');
            $table->string('tel');
            $table->string('id_card');
            $table->text('address')->nullable();
            $table->string('product_name');
            $table->string('product_id');
            $table->string('photo')->nullable();
            $table->float('price');
            $table->float('rate');
            $table->date('start_date');
            $table->date('end_date');
            $table->text('note')->nullable();
            $table->enum('status', ['progressing', 'completed'])->default('progressing');
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('mortgages');
    }
}
