<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGarantorsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('garantors', function(Blueprint $table)
		{
			$table->increments('id');
            $table->string('full_name_kh');
            $table->string('full_name_en');
            $table->enum('gender', ['m','f'])->default('m');
            $table->string('id_card_no');
            $table->string('tel');
            $table->text('address')->nullable();
            $table->text('note')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('garantors');
	}

}
