<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCompaniesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('companies', function(Blueprint $table)
		{
			$table->increments('id');
            $table->string('name_kh')->nullable();
            $table->string('name_en')->nullable();
            $table->string('id_of_company')->nullable();
            $table->string('house_number')->nullable();
            $table->string('road_number')->nullable();
            $table->string('group_numner')->nullable();
            $table->string('village')->nullable();
            $table->string('commune')->nullable();
            $table->string('district')->nullable();
            $table->string('province')->nullable();
            $table->string('company_tel')->nullable();
            $table->string('contact_time')->nullable();
            $table->string('email')->nullable();
            $table->string('ceo_section');
            $table->enum('position', ['ceo', 'manager', 'full_time', 'part_time'])->default('full_time');
            $table->enum('job_condition', ['always', 'sometime'])->default('always');
            $table->date('hired_date')->nullable();
            $table->enum('company_type', [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,,13])->default(13);
            $table->float('salary')->nullable();
            $table->float('other_salary')->nullable();
            $table->float('total_salary')->nullable();
            $table->integer('day_of_salary')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('companies');
	}

}
