<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReceiptIncomesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('receipt_incomes', function(Blueprint $table)
		{
			$table->increments('id');
            $table->string('receipt_id');
            $table->string('payment_name');
            $table->float('total_amount');
            $table->string('total_as_letter');
            $table->string('in_digit_of');
            $table->string('with_doc');
            $table->string('note')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('receipt_incomes');
	}

}
