<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePaymentsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('payments', function(Blueprint $table)
		{
			$table->increments('id');
            $table->date('payment_date');
            $table->float('amount');
            $table->integer('late_day')->nullable();
            $table->timestamp('fee_date')->nullable();
            $table->float('fee_late')->nullable();
            $table->boolean('is_paid_all')->default(false);
            $table->boolean('is_paid')->default(false);
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('payments');
	}

}
