<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstallmentsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('installments', function(Blueprint $table)
		{
			$table->increments('id');
            $table->integer('customer_id')->unsigned()->nullable();
            $table->string('type_of_product');
            $table->string('name');
            $table->string('model');
            $table->string('imie');
            $table->string('imie2')->nullable();
            $table->float('total_price');
            $table->float('deposit');
            $table->float('rate');
            $table->integer('duration');
            $table->enum('status', ['pendding', 'proccessing', 'completed'])->default('pendding');
            $table->text('note')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
            Schema::drop('installments');
	}

}
