<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLoanCustomersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('loan_customers', function(Blueprint $table)
		{
			$table->increments('id');
            $table->string('full_name_kh');
            $table->string('full_name_en');
            $table->enum('gender', ['m','f'])->default('m');
            $table->enum('marital_status', ['single', 'married'])->default('single');
            $table->enum('nationality', ['khmer', 'other'])->default('khmer');
            $table->date('dob');
            $table->string('id_card_no');
            $table->string('tel');
            $table->string('education')->nullable();
            $table->string('house_number')->nullable();
            $table->string('road_number')->nullable();
            $table->string('group_numner')->nullable();
            $table->string('village')->nullable();
            $table->string('commune')->nullable();
            $table->string('district')->nullable();
            $table->string('province')->nullable();
            $table->enum('property', ['owner', 'parents', 'sibling','rent_house', 'others'])->default('owner');
            $table->date('date_of_stay')->nullable();
            $table->enum('live_with', ['parents', 'wife','sibling', 'friend','single','others'])->default('parents');
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('loan_customers');
	}

}
