<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstallmentsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('installments', function(Blueprint $table)
		{
			$table->increments('id');
            $table->integer('customer_id')->unsigned();
            $table->string('product_name');
            $table->float('total_price')->unsigned();
            $table->float('rate')->unsigned();
            $table->integer('duration')->unsigned();
            $table->float('deposit');
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('installments');
	}

}
