<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSupplierInvoicesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('supplier_invoices', function(Blueprint $table)
		{
			$table->increments('id');
			$table->enum('status', ['draft','unpaid', 'paid', 'deposit'])->default('draft');
			$table->float('total')->unsigned()->nullable()->default(0);
			$table->float('pay')->unsigned()->nullable()->default(0);
			$table->float('changed')->unsigned()->nullable()->default(0);
			$table->float('payable')->unsigned()->nullable()->default(0);
			$table->integer('stock_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('supplier_id')->nullable();
			$table->integer('referral_id')->nullable();
			$table->integer('rate')->nullable();
			$table->integer('tax')->nullable();
			$table->text('comment')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('supplier_invoices');
	}

}
