<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('Orders', function(Blueprint $table)
		{
			$table->increments('id');
			$table->integer("invoice_id")->nullable()->unsigned()->default(0);
			$table->integer("product_id")->nullable()->default(0);
			$table->integer("amount")->unsigned()->nullable()->default(0);
			$table->integer("stock_id")->nullable();
			$table->float("price")->unsigned()->nullable()->default(0);
			$table->integer("discount")->nullable()->default(0);
			$table->integer("note")->nullable();
			$table->boolean("sold")->nullable()->default(false);
			$table->timestamps();
		});
		Schema::table('Orders', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('Invoices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('Orders');
		Schema::table('Orders', function(Blueprint $table) {
			$table->dropForeign('Order_invoice_id_foreign');
		});
	}

}
