<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('Invoices', function(Blueprint $table)
		{
			$table->increments('id');
			$table->enum('status', array('open','closed','draft'))->nullable()->default('open');
			$table->float("total")->unsigned()->nullable()->default(0);
			$table->float("recieved")->unsigned()->nullable()->default(0);
			$table->float("changed")->unsigned()->nullable()->default(0);
			$table->float("deposit")->unsigned()->nullable()->default(0);
			$table->integer("stock_id")->nullable()->default(0);
			$table->integer('user_id')->nullable();
			$table->integer("customer_id")->nullable();
			$table->integer('referral_id')->nullable();
			$table->integer('rate')->nullable();
			$table->text("comment")->nullable();
			$table->timestamps();

		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('Invoices');
	}

}
