<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('Settings', function(Blueprint $table)
		{
			$table->increments('id');
			$table->timestamps();
			$table->string('meta_key')->nullable();
			$table->string('meta_value')->nullable();
			$table->string('group')->nullable();
			$table->string('input_type')->nullable()->default("text");
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('Settings');
	}

}
