<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class AddFieldsToProductsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('Products', function(Blueprint $table)
		{
			$table->string('ref_id',20)->nullable();
			$table->boolean('is_expiring')->nullable();
			$table->boolean('turn_off_notification')->nullable();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('Products', function(Blueprint $table)
		{
			$table->dropColumn('ref_id');
			$table->dropColumn('is_expiring');
			$table->dropColumn('turn_off_notification');
		});
	}

}
