<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHistoriesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('Histories', function(Blueprint $table)
		{
			$table->increments('id');
			$table->integer('product_id')->unsigned()->nullable();
			$table->integer('amount')->nullable()->default(0);
			$table->string('operation_type')->nullable();
			$table->integer('user_id')->nullable()->unsigned();
			$table->string('operated_on',20)->nullable();
			$table->timestamps();
		});
		Schema::table("Histories",function(Blueprint $table){
			$table->foreign('user_id')->references('id')->on('Users')
						->onUpdate('no action')->onDelete('no action');
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('Histories');
		Schema::table("Histories",function(Blueprint $table){
			$table->dropForeign('History_user_id_foreign');
		});
	}

}
