<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserRoleIdForeignKeys extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('Users', function(Blueprint $table)
		{
			$table->foreign('role_id')->references('id')->on("Roles")->onDelete("set null")->onUpdate("set null");
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table("Users",function(Blueprint $table) {
			$table->dropForeign("User_role_id_foreign");
		});
	}

}
