<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class AddUnitIdColumnToProductTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('Products', function(Blueprint $table)
		{
			$table->integer("unit_id")->unsigned()->nullable();
			$table->foreign("unit_id")->references("id")->on("Units")->onDelete("set null")->onUpdate("set null");
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('Products', function(Blueprint $table)
		{
			$table->dropForeign('Product_unit_id_foreign');
		});
	}

}
