<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('product_category_id')->references('id')->on('ProductCategories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('Suppliers')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('item_location_id')->references('id')->on('itemLocations')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('Branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Users',function(Blueprint $table) {
			$table->foreign("position_id")->references('id')->on("Positions")->onUpdate('set null')->onDelete('set null');
		});
		Schema::table('Suppliers',function(Blueprint $table) {
			$table->foreign("position_id")->references('id')->on("Positions")->onUpdate('set null')->onDelete('set null');
		});
	}

	public function down()
	{
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Product_product_category_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Product_user_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Product_supplier_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Product_item_location_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('User_branch_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('User_position_id_foreign');
		});
		Schema::table('Suppliers', function(Blueprint $table) {
			$table->dropForeign('Supplier_position_id_foreign');
		});
	}
}
