<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutletsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('Stocks',function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('description');
			$table->integer('branch_id')->unsigned()->nullable();
		});
		Schema::create('Outlets', function(Blueprint $table)
		{
			$table->increments('id');
			$table->timestamps();
			$table->integer("product_id")->unsigned()->nullable();;
      $table->float("price");
      $table->integer("discount")->unsigned()->nullable()->default("0");
      $table->integer("user_id")->unsigned()->nullable();;
      $table->integer("amount")->unsigned();
      $table->string("sku");
      $table->integer("stock_id")->unsigned()->nullable();
      $table->text("note")->nullable();
		});
		Schema::table('Outlets', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('Outlets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('Outlets', function(Blueprint $table) {
			$table->foreign('stock_id')->references('id')->on('Stocks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Stocks', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('Branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('Stocks');
		Schema::drop('Outlets');
		Schema::table('Outlets', function(Blueprint $table) {
			$table->dropForeign('Outlets_product_id_foreign');
		});
		Schema::table('Outlets', function(Blueprint $table) {
			$table->dropForeign('Outlets_user_id_foreign');
		});
		Schema::table('Outlets', function(Blueprint $table) {
			$table->dropForeign('Outlets_branch_id_foreign');
		});
		Schema::table('Outlets', function(Blueprint $table) {
			$table->dropForeign('Outlets_branch_id_foreign');
		});
		Schema::table('Outlets', function(Blueprint $table) {
			$table->dropForeign('Outlets_stock_id_foreign');
		});
		Schema::table('Stocks', function(Blueprint $table) {
			$table->dropForeign('Stocks_branch_id_foreign');
		});
	}

}
