<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class AddSexToUserTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('Users', function(Blueprint $table)
		{
			$table->enum('sex', array('Male', 'Female', 'Other'))->nullable()->after('last_name');
			$table->date('date_of_birth')->nullable();
			$table->string('id_number',15)->nullable();
			$table->string('photo',255)->nullable();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('Users', function(Blueprint $table)
		{
			$table->dropColumn('sex');
			$table->dropColumn('date_of_birth');
			$table->dropColumn('id_number');
			$table->dropColumn('photo');
		});
	}

}
