<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('Customers', function(Blueprint $table)
		{
			$table->increments('id');
			$table->string('last_name')->nullable();
			$table->string('first_name')->nullable();
			$table->string('sex')->nullable();
			$table->string('tel')->nullable();
			$table->string('email')->nullable();
			$table->integer('age')->nullable();
			$table->text('address')->nullable();
			$table->text('photo', 255)->nullable();
			$table->text('note')->nullable();
			$table->integer('branch_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('Customers');
	}

}
