<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 50)->nullable();
			$table->string('last_name', 50)->nullable();
			$table->string('username', 20)->nullable();
			$table->string('email', 30)->nullable();
			$table->text('remember_token')->nullable();
			$table->text('address')->nullable();
			$table->string('tel', 30)->nullable();
			$table->integer('position_id')->unsigned()->nullable();
			$table->float('salary')->nullable();
			$table->string('allow_ip', 50)->nullable();
			$table->text('session_id')->nullable();
			$table->enum('status', array('active', 'suspended', 'inactive'))->nullable();
			$table->integer('role_id')->unsigned()->nullable();
			$table->integer('branch_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}