<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('Suppliers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('company_name')->nullable();
			$table->string('contact_name', 20)->nullable();
			$table->string('contact_tel', 20)->nullable();
			$table->text('address')->nullable();
			$table->string('tel', 30)->nullable();
			$table->string('company_email', 30)->nullable();
			$table->string('contact_email', 30)->nullable();
			$table->string('contact_photo', 255)->nullable();
			$table->string('logo', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Suppliers');
	}
}
