<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('Products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('sku', 15)->nullable();
			$table->text('name')->nullable();
			$table->text('name_kh')->nullable();
			$table->float('price_in')->nullable();
			$table->float('price')->nullable();
			$table->float('price_wholesale')->nullable();
			$table->integer('discount')->nullable();
			$table->integer('product_category_id')->unsigned()->nullable();
			$table->string('thumbnail', 255)->nullable();
			$table->integer('amount')->unsigned();
			$table->integer('min_amount')->unsigned()->nullable()->default('1');
			$table->integer('user_id')->unsigned()->nullable();;
			$table->boolean('is_service')->nullable();
			$table->datetime('expired_date')->nullable();
			$table->integer('supplier_id')->unsigned()->nullable();
			$table->integer('item_location_id')->unsigned()->nullable();
			$table->text('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Products');
	}
}
