<?php

class SettingsController extends \BaseController {

	/**
	 * Display a listing of the resource.
	 * GET /settings
	 *
	 * @return Response
	 */
	public function index()
	{
		$company = Setting::whereGroup('company_info')->get();
		$invoice = Setting::whereGroup('invoice')->get();
		$style = Setting::whereGroup('style')->get();
		$mortgage = Setting::whereGroup('mortgage')->get();
		return View::make('settings.index',[
		    'company' => $company,
            'invoice' => $invoice,
            'style' => $style,
            'mortgage' => $mortgage
        ]);
	}


	/**
	 * Show the form for creating a new resource.
	 * GET /settings/create
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 * POST /settings
	 *
	 * @return Response
	 */
	public function store()
	{

		if(Input::hasFile('company_logo')) {
			$file = Input::file('company_logo');
			$destinationPath = public_path() . DIRECTORY_SEPARATOR . "uploads/";
			$filename = $file->getClientOriginalName();
			$fileFolder = "uploads/";
			$filename = uniqid(). "_" . strtolower($filename);
			$filename = $fileFolder.$filename;
			Input::file('company_logo')->move($destinationPath, $filename);
			Setting::where('meta_key','=',"company_logo")->update(['meta_value'=>$filename]);
		}
        if(Input::hasFile('company_banner')) {
            $file = Input::file('company_banner');
            $destinationPath = public_path() . DIRECTORY_SEPARATOR . "uploads/";
            $filename = $file->getClientOriginalName();
            $fileFolder = "uploads/";
            $filename = uniqid(). "_" . strtolower($filename);
            $filename = $fileFolder.$filename;
            Input::file('company_banner')->move($destinationPath, $filename);
            Setting::where('meta_key','=',"company_banner")->update(['meta_value'=>$filename]);
        }
        $inputs = Input::except('_token','submit', 'company_logo', 'company_banner');
        foreach ($inputs as $input => $key) {
            Setting::where('meta_key','=',$input)->update(['meta_value'=>$key]);
        }
		return Redirect::back()->withInput()->with('message','messages.success-to-update')->with('messageType','success');
	}


	/**
	 * Display the specified resource.
	 * GET /settings/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 * GET /settings/{id}/edit
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 * PUT /settings/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 * DELETE /settings/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}