<?php

class ServiceController extends \BaseController {

	/**
	 * Display a listing of the resource.
	 * GET /service
	 *
	 * @return Response
	 */
	public function index()
	{
		$services = Service::orderBy('created_at', 'DESC');
		if (!empty(Input::get('type')) && Input::get('type') != "all") {
			$services->where('status', Input::get('type'));
		}
		if (!empty(Input::get('invoice_id'))) {
			$services->where('id', Input::get('invoice_id'));
		}
		if (!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
			$services->whereBetween('created_at', [Input::get('start_date'), Input::get('end_date')]);
		}
		return View::make('services.index', ['services' => $services->paginate(10)]);
	}

	/**
	 * Show the form for creating a new resource.
	 * GET /service/create
	 *
	 * @return Response
	 */
	public function create()
	{
		$service = new Service;
		return View::make('services.create', ['service' => $service]);
	}

	/**
	 * Store a newly created resource in storage.
	 * POST /service
	 *
	 * @return Response
	 */
	public function store()
	{
		$service = new Service;
		$service->duration = Input::get('duration');
		$service->tel      = Input::get('tel');
		$service->model    = Input::get('model');
		$service->product_name = Input::get('product_name');
		$service->is_warranty  = Input::get('is_warranty');
 		$service->note     = Input::get('note');
		if ($service->save()) return Redirect::back()->withMessage('messages.success-to-create')
																					->with('messageType', 'success');
		return Redirect::back()->withInput()->withMessage('messages.fail-to-create')->with('messageType', 'danger');
	}

	/**
	 * Display the specified resource.
	 * GET /service/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		$service = Service::find($id);
		return View::make('services.show', ['service' => $service]);
	}

	/**
	 * Show the form for editing the specified resource.
	 * GET /service/{id}/edit
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		$service = Service::find($id);
		if (empty($service)) return Redirect::back();
		return View::make('services.create', ['service' => $service]);
	}

	/**
	 * Update the specified resource in storage.
	 * PUT /service/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		$data = Input::except('_token', '_method');
		if (empty(Input::get('is_warranty'))) $data['is_warranty'] = 0;
		$service = Service::find($id);
		$ser = $service->update($data);
		if ($ser) return Redirect::back()->withMessage('messages.success-to-update')
																					->with('messageType', 'success');
		return Redirect::back()->withInput()->withMessage('messages.fail-to-update')->with('messageType', 'danger');
	}

	/**
	 * Remove the specified resource from storage.
	 * DELETE /service/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}
	public function send()
	{
		$service = Service::find(Input::get('service_id'));
		$sendDate = new Carbon\Carbon(Input::get('send_date'));
		$service->send_date = $sendDate;
		$service->is_send = true;
		$service->save();
		return Redirect::back()->withMessage('services.msg.send')
										->with('messageType', 'success');
	}

	public function completed()
	{
		$services = Service::completed();
		return View::make('services.completed', ['services' => $services]);
	}

	public function print($id = null)
	{
		$receipId = !empty(Session::get('printReceipt')) ? Session::get('printReceipt') : $id;
		$service = Service::find($receipId);
		return View::make('services.receipt', ['service' => $service]);	
	}
	public function callCheckout()
	{
		$service_id = Input::get('service_id');
		$service    = Service::find($service_id);
		if (empty($service)) return Redirect::back();
		if (Input::get('call')) {
			$service->call +=1;
			$service->save();
			return Redirect::back()->withMessage('services.msg.called')->with('messageType', 'success');
		} else {
			Session::put('printReceipt', $service_id);
			$service->status = "paid";
			$invoiceUrl = route('services.print');
			$index = route('services.index');
			$newProfit = new Profit;
			$newProfit->type = "income";
			$newProfit->description = "Income from receipt ". convertInvoiceNumber($service->id);
			if ($service->price > 0) {
				$newProfit->amount = $service->price;
				$newProfit->save();
			}
			if ($service->save()) {
				return '
	      <script type="text/javascript">
	        window.open("'.$invoiceUrl.'", "_blank");
	        window.location = "'.$index.'";
	      </script>
	      ';
			}
		}
		return Redirect::back();
	}

	public function updateDetail()
	{
		$service_id = Input::get('service_id');
		$service    = Service::find($service_id);
		if (empty($service)) return Redirect::back();
		if (Input::get('repairing')) {
			$service->status = "repairing";
			$service->detail = Input::get('detail');
			$service->price  = Input::get('service_charge');
			$service->save();
			return Redirect::back()->withMessage('services.msg.start_repair')
										 ->with('messageType', 'success');
		} else {
			$service->status = "completed";
			if (!empty(Input::get('recieved_date'))) {
				$service->recieved_date = Input::get('recieved_date');
			}
			$service->detail = Input::get('detail');
			$service->price  = Input::get('service_charge');
			$service->save();
			return Redirect::route('services.index')
										 ->withMessage('services.msg.completed')
										 ->with('messageType', 'success');
		}
	}
}