<?php

class ProfitsController extends \BaseController {

	/**
	 * Display a listing of the resource.
	 * GET /profits
	 *
	 * @return Response
	 */
	public function index()
	{
		if(!UserRole::has('create_income')) return Redirect::route('dashboard');
		return View::make('Profits.index');
	}

	/**
	 * Show the form for creating a new resource.
	 * GET /profits/create
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 * POST /profits
	 *
	 * @return Response
	 */
	public function store()
	{
		if (Input::get('amount') > 0) {
			$profit = new Profit();
			$profit->user_id = Auth::user()->id;
			$profit->amount = (float) Input::get('amount');
			$profit->type = Input::get('type');
			$profit->rate = \Helper::getConfig('invoice_rate');
			$profit->description = Input::get('description');
			if ($profit->save()) return Redirect::back()->withInput()->withMessage('messages.success-to-create')->with('messageType', 'success');
			return Redirect::back()->withInput()->withMessage('messages.fail-to-create')->with('messageType', 'danger');
		} else {
			return Redirect::back()->withInput()->withMessage('messages.fail-to-create')->with('messageType', 'danger');
		}
	}

	/**
	 * Display the specified resource.
	 * GET /profits/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 * GET /profits/{id}/edit
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		$profits = Profit::take(20)->orderBy('created_at', 'desc')->get();
		$profit = Profit::whereNull('invoice_id')->find($id);
		if (empty($profit)) return Redirect::route('profits.index');
		return View::make('Profits.edit')->withProfit($profit)->withProfits($profits);
	}

	/**
	 * Update the specified resource in storage.
	 * PUT /profits/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		$profit = Profit::find($id);
		if (empty($profit)) return Redirect::back();
		$profit->user_id = Auth::user()->id;
		$profit->amount = (float) Input::get('amount');
		$profit->type = Input::get('type');
		$profit->rate = \Helper::getConfig('invoice_rate');
		$profit->description = Input::get('description');
		if ($profit->save()) return Redirect::back()->withInput()->withMessage('messages.success-to-update')->with('messageType', 'success');
		return Redirect::back()->withInput()->withMessage('messages.fail-to-update')->with('messageType', 'danger');
	}

	/**
	 * Remove the specified resource from storage.
	 * DELETE /profits/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}
	public function getProfits() {
		$profits = DB::table('Profits')->leftJoin('Users', 'Users.id', '=', 'Profits.user_id')
						->orderBy('Profits.id','ASC')
            ->select(['Profits.id','Profits.amount', 'Profits.type','Profits.description','Profits.invoice_id','Profits.created_at','Users.first_name as userName']);
   	 return Datatables::of($profits)
   	 				->editColumn('type',function($profit) {
 	 							return ucfirst($profit->type);
   	 				})
   	 				->editColumn('description',function($profit) {
							if(!empty($profit->description))
								return $profit->description;
   	 				})
   	 				->editColumn('invoice_id',function($profit) {
   	 					if(!empty($profit->invoice_id))
   	 						if(UserRole::has("list_invoice"))
   	 							return link_to_route("invoices.show",$profit->invoice_id, [$profit->invoice_id]);
   	 						else
   	 							return $profit->invoice_id;
   	 				})
   	 				->editColumn('amount',function($profit) {
   	 					return money($profit->amount);
   	 				})
            ->editColumn('action',
            	'
            	@if(UserRole::has("edit_income"))
	          		@if($invoice_id == null)
	                <a href="{{ Route("profits.edit",$id) }}" class="btn btn-xs btn-info">{{Trans("dashboard.crud.edit")}}</a>
	              @else
                	<a href="#" class="btn btn-xs btn-default disabled">{{Trans("dashboard.crud.edit")}}</a>
                @endif
              @endif
      				'
            )
            ->make(true);
	}

}
