<?php

class PositionsController extends \BaseController {

	/**
	 * Display a listing of the resource.
	 * GET /positions
	 *
	 * @return Response
	 */
	public function index()
	{
		if(!UserRole::has('create_position')) return Redirect::route('dashboard');
		$positions = Position::all();
		return View::make('Positions.create')->withPositions($positions);
	}

	/**
	 * Store a newly created resource in storage.
	 * POST /positions
	 *
	 * @return Response
	 */
	public function store()
	{
		$data = Input::except('_token', 'submit');
		$position = DB::table('positions')
								->whereName(Input::get('name'))
								->whereFor(Input::get('for'))
								->get();
		if(!empty($position))
			return Redirect::back()
			->withInput()
			->withMessage('messages.duplicated_name')
			->with('messageType', 'danger');

		$position = Position::create($data);
		if ($position) {
	 		return Redirect::back()
				->withInput()
				->withMessage('messages.success-to-create')
				->with('messageType', 'success');
		} else {
			return Redirect::back()
				->withInput()
				->withMessage('messages.fail-to-create')
				->with('messageType', 'danger');
		}
	}
	/**
	 * Show the form for editing the specified resource.
	 * GET /positions/{id}/edit
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		if(!UserRole::has('edit_position')) return Redirect::route('dashboard');
		$positions = Position::all();
		$position = Position::find($id);
		if (!$positions) Redirect::back();
		return View::make('Positions.edit')
			->withPosition($position)
			->withPositions($positions);
	}

	/**
	 * Update the specified resource in storage.
	 * PUT /positions/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		$position = DB::table('positions')
								->whereName(Input::get('name'))
								->whereFor(Input::get('for'))
								->where('id', '<>', $id)
								->get();
		if(!empty($position))
			return Redirect::back()
			->withInput()
			->withMessage('messages.duplicated_name')
			->with('messageType', 'danger');

		$position = Position::find($id);
		$position->name = Input::get('name');
		$position->for = Input::get('for');
		$result = $position->save();
		if ($result) {
	 		return Redirect::route('positions.index')
				->withMessage('messages.success-to-update')
				->with('messageType', 'success');
		} else {
			return Redirect::back()
				->withInput()
				->withMessage('messages.fail-to-update')
				->with('messageType', 'danger');
		}
	}

	/**
	 * Remove the specified resource from storage.
	 * DELETE /positions/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		$position = Position::find($id);
		if(empty($position)) Redirect::back()
			->withMessage('messages.fail-to-delete')
			->with('messageType', 'danger');
		$result = $position->delete();
		if (!$result) return Redirect::back()->withMessage('messages.fail-to-delete')->with('messageType', 'danger');
		return Redirect::route('positions.index')->withMessage('messages.success-to-delete')->with('messageType', 'success');

	}

}
