<?php

class OutletsController extends \BaseController {

	/**
	 * Transfer To Stock
	 */
	public static function store()
	{
		$success = false;
		$data = Input::all();
		$id = $data['id'];
		DB::beginTransaction();
		try {
			$outlet = Outlet::find($id);
			if($outlet->available_amount < $data['amount'] && $outlet->is_service == false) {
				return Redirect::back()->withInput()->with('message','messages.not_enought_amount')->with('messageType','danger');
			}
			$product_id = $outlet->product_id;
			$stock_id		= $data['stock_id'];
			$existed_item = Outlet::where(function($query) use($product_id,$stock_id) {
				$query->where('product_id','=',$product_id)
				->where('stock_id','=',$stock_id);
			})->first();   
			if($existed_item) {
				//return ['Checkou Item Outlet Here'];
				$outletExist = Outlet::find($existed_item->id);
				$outletExist->amount += $data['amount'];
				$outletExist->available_amount += $data['amount'];
				$outletExist->user_id = Auth::user()->id;
				if (!empty(Input::get('location'))) {
					$outletExist->location = Input::get('location');
				}
				$outletExist->save();
				/*
				Deduct From Stock
				 */
				$adjustOutlet = Outlet::find($data['id']);
				$adjustOutlet->amount =	$adjustOutlet->amount - $data['amount'];
				$adjustOutlet->available_amount =	$adjustOutlet->available_amount - $data['amount'];
				$adjustOutlet->save();
				if(History::stockHistory($outletExist->product_id, $data) && 
							History::stockHistory($outletExist->product_id, [
								'amount' => $data['amount'], 
								'stock_id' => Input::get('c_stock_id')], 'out')) {
						$success = true;
					}
					else{
						$success = false;
					}
			}
			else {
				$outlet = Outlet::create([
					'product_id' 	=> $outlet->product_id,
					'amount'			=> $data['amount'],
					'available_amount'			=> $data['amount'],
					'user_id'			=> Auth::user()->id,
					'price'				=> $outlet->price,
					'sku'					=> $outlet->sku,
					'stock_id'		=> $data['stock_id'],
					'location'    => Input::get('location')
				]);
				if($outlet) {
				/*
				Deduct From Stock
				 */
				$adjustOutlet = Outlet::find($data['id']);
				$adjustOutlet->amount =	$adjustOutlet->amount - $data['amount'];
				$adjustOutlet->available_amount =	$adjustOutlet->available_amount - $data['amount'];
				$adjustOutlet->save();
					/*
					Add to Log Data
					*/
					if(History::stockHistory($outlet->product_id, $data) && 
							History::stockHistory($outlet->product_id, [
								'amount' => $data['amount'], 
								'stock_id' => Input::get('c_stock_id')], 'out')) {
						$success = true;
					}
					else{
						$success = false;
					}

				}
			}
		} catch (\Exception $e) {
			return dd($e);
		}
		if (!$success) {
			DB::rollback();
			return Redirect::back()->withInput()->with('message','messages.fail-to-transfer')->with('messageType','danger');
		} else {
			DB::commit();
		return Redirect::back()->with('message','messages.success-to-transfer')->with('messageType','success');
		}
	}

	/**
	 * Display the specified resource.
	 * GET /outlets/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		$outlet 		= Outlet::find($id);
		if (empty($outlet)) return Redirect::route('stocks.index');
		$stock_id		= $outlet->stock_id;
		$product_id		= $outlet->product_id;
		$outlet = Outlet::productByID($id);
		$histories = DB::table('Histories')
									->join('Products','Products.id','=','Histories.product_id')
									->where(function($query) use($product_id,$stock_id) {
										$query->where('product_id','=',$product_id)
													->where('operated_on','=','stock')
													->where('stock_id','=',$stock_id);
									})->select('Histories.*','Products.name as pname')
									->orderBy('Histories.created_at', "DESC")
									->paginate(10);
		$stocks = Stock::where('id','<>',$stock_id)->lists('name','id');
		$stock = Stock::where('id', '<>', $stock_id)->first();
		return View::make('outlets.show', [
							'outlet' => $outlet,
							'histories'=>$histories,
							'stocks'=>$stocks,
							'stock' => $stock
					]);
	}
	/**
	 * Remove the specified resource from storage.
	 * DELETE /outlets/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		Stock::destroy($id);
		return Redirect::route('stocks.index')->with('message','messages.success-to-delete')->with('messageType','success');
	}

}