<?php

class ItemLocationsController extends \BaseController {

	private $path = "uploads/item_locations/";
	/**
	 * Display a listing of the resource.
	 * GET /itemlocations
	 *
	 * @return Response
	 */
	public function index()
	{
		if(!UserRole::has('list_location')) return Redirect::route('dashboard');
        $item_location = new ItemLocation;
		$item_locations = ItemLocation::all();
		return View::make('itemLocations.index')
                                ->withItem_location($item_location)
								->withItem_locations($item_locations);
	}

	/**
	 * Show the form for creating a new resource.
	 * GET /itemlocations/create
	 *
	 * @return Response
	 */
	public function create()
	{
		if(!UserRole::has('create_location')) return Redirect::route('dashboard');
		return View::make('itemLocations.create');
	}

	/**
	 * Store a newly created resource in storage.
	 * POST /itemlocations
	 *
	 * @return Response
	 */
	public function store()
	{
		$data = Input::except('_token','submit');
		$validator = Validator::make(Input::all(), ItemLocation::$rules);
		if ($validator->fails()) return Redirect::back()
																		->withInput()
																		->withMessage('messages.duplicated_name')
																		->with('messageType', 'danger');
		if(Input::hasFile('picture')) {
			$image = Input::file('picture');
		 	if($image->getClientSize() > getLimitSize()) {
				return Redirect::back()
												->withInput()
												->with('message','messages.fail-to-upload')
												->with('messageType','danger');
			}
			$data['picture'] = \Helper::uploadFile(Input::file('picture'), $this->path);
		} else {
			$data['picture'] = \Config::get('app.ip').'uploads/none.jpg';
		}
		$item_location = ItemLocation::create($data);
		if ($item_location) return Redirect::back()
													->withInput()
													->with('message','messages.success-to-create')
													->with('messageType','success');
		return Redirect::back()
													->withInput()
													->with('message','messages.fail-to-create')
													->with('messageType','danger');


	}
	/**
	 * Display the specified resource.
	 * GET /itemlocations/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{

	}

	/**
	 * Show the form for editing the specified resource.
	 * GET /itemlocations/{id}/edit
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		if(!UserRole::has('edit_location')) return Redirect::route('dashboard');
		$item_location = ItemLocation::find($id);
        $item_locations = ItemLocation::where('id', $id)->get();
		if (empty($item_location)) return Redirect::route('item_locations.create');
		return View::make('itemLocations.index')
                    ->withItem_locations($item_locations)
                    ->withItem_location($item_location);
	}

	/**
	 * Update the specified resource in storage.
	 * PUT /itemlocations/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		$data = Input::except('_token','submit');
		$item_location = ItemLocation::find($id);
		$validator = Validator::make(Input::all(), ItemLocation::$rules);
		if ($item_location->name == Input::get('name')) {
			$item_location->name = Input::get('name');
		} else {
			if ($validator->fails()) return Redirect::back()
																			->withInput()
																			->withMessage('messages.duplicated_name')
																			->with('messageType', 'danger');
		}
		if(Input::hasFile('picture')) {
			$image = Input::file('picture');
		 	if($image->getClientSize() > getLimitSize()) {
				return Redirect::back()
												->withInput()
												->with('message','messages.fail-to-upload')
												->with('messageType','danger');
			}
			$data['picture'] = \Helper::uploadFile(Input::file('picture'), $this->path);
		} else {
			$data['picture'] = $item_location->picture;
		}
		$item = $item_location->update($data);
		if ($item) return Redirect::back()
															->withInput()
															->with('message','messages.success-to-update')
															->with('messageType','success');
		return Redirect::back()
										->withInput()
										->with('message','messages.fail-to-update')
										->with('messageType','danger');

	}

	/**
	 * Remove the specified resource from storage.
	 * DELETE /itemlocations/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		$item = ItemLocation::find($id);
		if(empty($item)) Redirect::back()
										->with('message','messages.fail-to-delete')
										->with('messageType','danger');
		if ($item->delete()) return Redirect::back()
																->with('message','messages.success-to-delete')
																->with('messageType','success');
		return Redirect::back()
										->with('message','messages.fail-to-delete')
										->with('messageType','danger');
	}
}
