<?php

class CategoriesController extends \BaseController {
	/**
	 * Render View to create categories
	 */
	public function getCreate()
	{
		if(!UserRole::has('add_category')) return Redirect::route('dashboard');
		$categories = ProductCategory::all();
		return View::make('categories.create')->withCategories($categories);
	}
	/**
	 * Store the form value
	 * to create new category
	 */
	public function postCreate()
	{
		$validator = Validator::make(Input::all(), ProductCategory::$rules);
		if ($validator->fails()) return Redirect::back()
														->withInput()
														->withMessage('messages.duplicated_name')
														->with('messageType', 'danger');
		$data = Input::only(['name', 'icon', 'comment']);
		if (Input::hasFile('icon')) {
			$data['icon'] =  Helper::uploadFile(Input::file('icon'), "uploads/icons/");
		} else {
			$data['icon'] = \Config::get('app.ip').'uploads/none.jpg';
		}
		if (ProductCategory::create($data)) return Redirect::back()
												->withMessage('messages.success-to-create')
												->with('messageType', 'success');

		return Redirect::back()
												->withInput()
												->withMessage('messages.fail-to-create')
												->with('messageType', 'danger');
	}
	public function getUpdate($id)
	{
		if(!UserRole::has('edit_category')) return Redirect::route('dashboard');
		$category = ProductCategory::find($id);
		if (empty($category)) return Redirect::route('categories.create');
		$categories = ProductCategory::all();
		return View::make('categories.edit')
								->withCategory($category)
								->withCategories($categories);
	}
	public function postUpdate($id)
	{
		$category = ProductCategory::find($id);
		$validator = Validator::make(Input::all(), ProductCategory::$rules);
		if ($category->name == Input::get('name')) {
			$category->name = Input::get('name');
		} else {
			if ($validator->fails()) return Redirect::back()
															->withInput()
															->withMessage('messages.duplicated_name')
															->with('messageType', 'danger');
		}
		$category->name = Input::get('name');
		if (Input::hasFile('icon')) {
			$category->icon = Helper::uploadFile(Input::file('icon'), "uploads/icons/");
		}
		$category->comment = Input::get('comment');
		if ($category->save()) return Redirect::route('categories.create')
														->with('message','messages.success-to-update')
														->with('messageType','success');
		return Redirect::back()
										->withInput()
										->with('message','messages.fail-to-update')
										->with('messageType','danger');
	}
	public function postDelete($id)
	{
		$category = ProductCategory::find($id);
		if(empty($category)) return Redirect::route('categories.create');
		if ($category->delete()) return Redirect::route('categories.create')
															->with('message','messages.success-to-delete')
															->with('messageType','success');
		return Redirect::route('categories.create')
										->with('message','messages.fail-to-delete')
										->with('messageType','danger');
	}

}
