<?php

class BrandsController extends \BaseController {

  private $brand;
  private $path = "uploads/brands/";
  public function __construct(Brand $brand)
  {
    $this->brand = $brand;
  }
	/**
	 * Display a listing of the resource.
	 * GET /brands
	 *
	 * @return Response
	 */
	public function index()
	{

		return View::make('brands.form', [
                'brand' => $this->brand,
                'brands'  =>  Brand::all()
              ]);
	}

	/**
	 * Show the form for creating a new resource.
	 * GET /brands/create
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 * POST /brands
	 *
	 * @return Response
	 */
	public function store()
	{
		$brand_name = Input::get('name');
    $exist_brand = Brand::where('name', $brand_name)->first();
    if ($exist_brand) return Redirect::back()->withInput()
       ->withMessage('brands.existing')->with('messageType', 'danger');
    $data = Input::only('name', "logo");
    if(Input::hasFile('logo')) {
		$data['logo'] = \Helper::uploadFile(Input::file('logo'), $this->path);
 		} else {
 			$data['logo'] = \Config::get('app.ip').'uploads/none.jpg';
 		}
 		$new_brand = Brand::create($data);
 		if ($new_brand) return Redirect::back()
 													->with('message','messages.success-to-create')
 													->with('messageType','success');
 		return Redirect::back()
 													->withInput()
 													->with('message','messages.fail-to-create')
 													->with('messageType','danger');

	}

	/**
	 * Display the specified resource.
	 * GET /brands/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 * GET /brands/{id}/edit
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		$brand = Brand::find($id);
    if (empty($brand)) return Redirect::back();
    return View::make('brands.form', ['brand' => $brand, 'brands' => Brand::all()]);
	}

	/**
	 * Update the specified resource in storage.
	 * PUT /brands/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		$brand = Brand::find($id);
    if (empty($brand)) return Redirect::back();
    $brand_name = Input::get('name');
    $exist_brand = Brand::where('name', $brand_name)->where('id', '<>', $id)->first();
    if ($exist_brand) return Redirect::back()->withInput()
       ->withMessage('brands.existing')->with('messageType', 'danger');
    $brand->name = $brand_name;
    if(Input::hasFile('logo')) {
		    $brand->logo = \Helper::uploadFile(Input::file('logo'), $this->path);
 		}
 		if ($brand->save()) return Redirect::route('brands.index')
 													->with('message','messages.success-to-update')
 													->with('messageType','success');
 		return Redirect::back()
 													->withInput()
 													->with('message','messages.fail-to-update')
 													->with('messageType','danger');
	}

	/**
	 * Remove the specified resource from storage.
	 * DELETE /brands/{id}
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		$brand = Brand::find($id);
    if (empty($brand)) return Redirect::back();
    if (count_product_in_brand($id) > 0) return Redirect::back()
        ->withMessage('messages.not_allow_to_delete')
        ->with('messageType', 'warning');
    if ($brand->delete()) return Redirect::route('brands.index')
        ->withMessage('messages.success-to-delete')
        ->with('messageType', 'success');
	}

  public function getBrands()
  {
    $profits = DB::table('Profits')->leftJoin('Users', 'Users.id', '=', 'Profits.user_id')
            ->orderBy('Profits.id','ASC')
            ->select(['Profits.id','Profits.amount', 'Profits.type','Profits.description','Profits.invoice_id','Profits.created_at','Users.first_name as userName']);
     return Datatables::of($profits)
            ->editColumn('type',function($profit) {
                return ucfirst($profit->type);
            })
            ->editColumn('description',function($profit) {
              if(!empty($profit->description))
                return $profit->description;
            })
            ->editColumn('invoice_id',function($profit) {
              if(!empty($profit->invoice_id))
                if(UserRole::has("list_invoice"))
                  return link_to_route("invoices.show",$profit->invoice_id, [$profit->invoice_id]);
                else
                  return $profit->invoice_id;
            })
            ->editColumn('amount',function($profit) {
              return money($profit->amount);
            })
            ->editColumn('action',
              '
              @if(UserRole::has("edit_income"))
                @if($invoice_id == null)
                  <a href="{{ Route("profits.edit",$id) }}" class="btn btn-xs btn-info">{{Trans("dashboard.crud.edit")}}</a>
                @else
                  <a href="#" class="btn btn-xs btn-default disabled">{{Trans("dashboard.crud.edit")}}</a>
                @endif
              @endif
              '
            )
            ->make(true);
  }
}
