<?php

class BranchesController extends \BaseController {

	/**
	 * Display a listing of branches
	 *
	 * @return Response
	 */
	public function index()
	{
		if(!UserRole::has('list_branch')) return Redirect::route('dashboard');
		if(Branch::getNumber() == 'one') {
			$branch = Branch::first();
			return View::make('branches.index', compact('branch'));
		} else {
			$branches = Branch::all();
			return View::make('branches.index', compact('branches'));
		}

	}

	/**
	 * Show the form for creating a new branch
	 *
	 * @return Response
	 */
	public function create()
	{
		if(!UserRole::has('create_branch')) return Redirect::route('dashboard');
		if(Branch::getNumber() == "one" && count(Branch::all()) >=1 ) return Redirect::route('dashboard');
		return View::make('branches.create');
	}

	/**
	 * Store a newly created branch in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		$data = Input::all();
		$validator = Validator::make(Input::all(),['name' => 'unique:branches']);
		if ($validator->fails())
		return Redirect::back()
					->withInput()
          ->withMessage('messages.fail-to-create')
          ->with('messageType', 'danger')
          ->withErrors($validator->messages());

		$branch = Branch::create($data);
		if($branch)
		return Redirect::back()
					->withInput()
					->with('message','messages.success-to-create')
					->with('messageType','success');
		return Redirect::back()
					->withInput()
					->with('message','messages.fail-to-create')
					->with('messageType','danger');
	}

	/**
	 * Display the specified branch.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		$branch = Branch::findOrFail($id);
		return View::make('branches.show', compact('branch'));
	}

	/**
	 * Show the form for editing the specified branch.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		if(!UserRole::has('edit_branch')) return Redirect::route('dashboard');
		$branch = Branch::find($id);
		return View::make('branches.edit')->with('branch',$branch);
	}

	/**
	 * Update the specified branch in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		$data = Input::all();
		$branch = Branch::find($id);
		$validator = Validator::make(Input::all(),['name' => 'unique:branches,name,'.$branch->id]);
		if ($validator->fails())
		return Redirect::back()
					->withInput()
          ->withMessage('messages.fail-to-create')
          ->with('messageType', 'danger')
          ->withErrors($validator->messages());
		$branch = $branch->update($data);
		if($branch)
			return Redirect::back()
				->withInput()
				->with('message','messages.success-to-update')
				->with('messageType','success');
		else
			return Redirect::back()
				->withInput()
				->with('message','messages.fail-to-update')
				->with('messageType','danger');
	}

	/**
	 * Remove the specified branch from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		$branch = Branch::find($id);
		if(empty($branch)) return Redirect::route('branches.index')
				->with('message','messages.fail-to-delete')
				->with('messageType','danger');
		$stock = Stock::where('branch_id', $id)->first();
		if(!empty($stock)) return Redirect::route('branches.index')
				->with('message','messages.not_allow_to_delete')
				->with('messageType','warning');
		if($branch->delete()) {
			return Redirect::route('branches.index')
				->with('message','messages.success-to-delete')
				->with('messageType','success');
		} else {
			return Redirect::route('branches.index')
					->with('message','messages.fail-to-delete')
					->with('messageType','danger');
		}
	}

}
