<?php
class AuthController extends \BaseController {

  public function getLogin() {
    // $users = DB::table('users')->lists('username');
    // return dd($users);
    
    if(Auth::check()) {
       return Redirect::to('/');
    }
    return View::make('login');
  }
  public function postLogin() {
    $data = Input::all();
    $validator = Validator::make($data, User::$auth_rules);
    if ($validator->fails()) {
      Session::save();
      return Redirect::back()->withInput()->withMessage("messages.required")->withType('alert-danger');
    }
    if (Auth::attempt([
        'username' => Input::get('username'),
        'password' => Input::get('password'),
        'status' => "active"
      ])) {
       return Redirect::intended('/');
    }
    return Redirect::route('form.login')->withInput()->with('message', "messages.incorrect")->withType('alert-danger');
  }
  public function getLogout() {
    Auth::logout();
    return Redirect::route('form.login')->withMessage('messages.logout')->withType('alert-success');
  }
}
